#include <stdio.h>
#include <string.h>
/* Note: We include t1lib.h from lib/t1lib. That way the objectfile does only
   need to be rebuild when the header itself changes and not each time the
   library has been recompiled */
#include "t1lib.h"

int type1afm(char *infile)
{

	int i, j, result;
	int rasterflags=0;
	/* If we want to log anything, then log all */

	j=1;
	T1_SetLogLevel(T1LOG_DEBUG);
	if ((T1_InitLib( NO_LOGFILE |
					IGNORE_CONFIGFILE |
					IGNORE_FONTDATABASE)==NULL)){
		fprintf(stderr, "Initialization of t1lib failed\n");
		return(1);
	}

	/* First, build font data base */
	if ((result=T1_AddFont(infile))<0)
		fprintf( stderr, "type1afm: Could not load font file %s (%d)\n",
				infile, result);

	if (T1_Get_no_fonts()<1){
		fprintf( stderr, "type1afm: Nothing to do\n");
		T1_CloseLib();
		return(-1);
	}

	/* switch rasterizer to disable hinting */
	rasterflags |= T1_IGNORE_FORCEBOLD;
	rasterflags |= T1_IGNORE_FAMILYALIGNMENT;
	rasterflags |= T1_IGNORE_HINTING;
	T1_SetRasterFlags( rasterflags);

	/* Second, load fonts and generate afm files */
	for( i=0; i<T1_Get_no_fonts(); i++){
		if ((T1_LoadFont(i))) {
			fprintf(stderr, "Load font %s failed\n", T1_GetFontFileName(i));
			continue;
		}
		result=T1_WriteAFMFallbackFile(i);
		T1_DeleteFont(i);
	}
	T1_CloseLib();
	return( 0);
}

