#define NAMELEN 128
#define MODE 0755
/*1:*/
#line 17 "gbkfonts.w"

/*2:*/
#line 23 "gbkfonts.w"

#include <stdio.h> 
#include <stdlib.h> 
#include <string.h> 
#include <stdarg.h> 
#include <errno.h> 
#include <signal.h> 
#include <freetype/freetype.h> 

#include "t1lib.h"

#include <locale.h> 
#include <libintl.h> 

#ifndef WIN32
#include <unistd.h> 
#include <sys/stat.h> 
#include <sys/types.h> 
#else
#include <windows.h> 
#include  <io.h> 


#define mkdir(a,b) _mkdir(a)
#define access _access

#endif

#define INSERT


char*LookUp_Name(int);

/*:2*//*13:*/
#line 234 "gbkfonts.w"

#ifdef INTERNATIONAL

#include <libintl.h> 
#include <locale.h> 
#define _(String) gettext (String)
#define PACKAGE "gbkfonts"
#define LOCALEDIR "/usr/share/locale"

#else
#define _(String) String

#endif

/*:13*/
#line 18 "gbkfonts.w"

/*3:*/
#line 58 "gbkfonts.w"

extern char fontname[],fam_name[];
unsigned short pid,eid;

/*:3*/
#line 19 "gbkfonts.w"

/*7:*/
#line 119 "gbkfonts.w"

char*trimpath(char*str)
{

char*ptr;
ptr= strrchr(str,'\\');
if(ptr==0)ptr= strrchr(str,'/');
if(ptr==0)return str;else return ptr+1;
}

/*:7*//*11:*/
#line 185 "gbkfonts.w"

void showhelp()
{
puts(_("Usage:  gbkfonts [-f] [-name str] [-prefix str] ttf_file facename"));
puts(_("\t          -f: fast, only create config and map files"));
puts(_("\t        -uid: select an unique ID for your font"));
puts(_("\t       -name: select an PostScript font name for you font"));
puts(_("\t -prefix str: add the prefix rather than \"gbk\" to you font name"));
puts(_("\t    ttf_file: TTF file name"));
puts(_("\t    facename: song/hei/kai/li/fs, etc."));
puts("");
puts(_("Example: gbkfonts -c -gbk /home/knuth/fonts/simsun.ttf song"));
puts("");
puts(_("Then copy folder \"dvips\", \"tex\", \"dvipdfm\", and \"fonts\" to TEXMFLOCAL"));
puts(_("Append file cjk.map, cid-x.map, pdftex.cfg, ttfonts.map to your system"));
puts(_("The script \"appendconf\" can help you append these files to the system"));
puts(_("The script \"go\" can help you create all fonts in a directory. Modify it as you like."));
}

/*:11*/
#line 20 "gbkfonts.w"

/*12:*/
#line 204 "gbkfonts.w"

int main(int argc,char*argv[])
{
/*8:*/
#line 129 "gbkfonts.w"

int i,fontuid= 0,nn;
FILE*pfbmapfile,*ttfmapfile,*fout,*dvipdfm_mapfile,*fd_file;

static char*prefix= "gbk",*ttf_file,*ttf_basename,*facename;
static char slface[NAMELEN],name[NAMELEN],slname[NAMELEN],plane[8];
static char cmd[NAMELEN],cmd1[NAMELEN];


static int bs= 0,bv= 0,bf= 0,font_name_detected= 0;


/*:8*//*14:*/
#line 248 "gbkfonts.w"

char*lc_all;

/*:14*//*16:*/
#line 263 "gbkfonts.w"

struct sigaction act;

/*:16*//*20:*/
#line 317 "gbkfonts.w"

char dvipsdir[NAMELEN],type1dir[NAMELEN],tfmdir[NAMELEN],afmdir[NAMELEN];

/*:20*/
#line 207 "gbkfonts.w"
;
/*15:*/
#line 251 "gbkfonts.w"

#ifdef INTERNATIONAL

lc_all= setlocale(LC_ALL,"");
if(!bindtextdomain(PACKAGE,NULL))
fprintf(stderr,"Can't bind to locale %s\n",lc_all);

puts(textdomain(PACKAGE));
if(textdomain(PACKAGE)==NULL)
fprintf(stderr,"Can't bind to locale %s\n",lc_all);
#endif

/*:15*/
#line 208 "gbkfonts.w"
;
/*17:*/
#line 266 "gbkfonts.w"

act.sa_handler= SIG_IGN;
sigaction(SIGCHLD,&act,NULL);

/*:17*/
#line 209 "gbkfonts.w"
;
/*18:*/
#line 270 "gbkfonts.w"

for(i= 1;i<argc;i++)
{
char*arg= argv[i];

if(arg[0]=='-'){
switch(arg[1]){
case's':bs= 1;break;
case'p':
i++;
prefix= argv[i];
break;
case'v':bv= 1;break;
case'f':bf= 1;break;
case'u':i++;
fontuid= atoi(argv[i]);
break;
case'n':i++;
strcpy(fontname,argv[i]);
break;
default:
showhelp();
exit(1);
}
}
else if(ttf_file==NULL)ttf_file= arg;
else if(facename==NULL)facename= arg;
else fputs(_("! Extra file names ignored\n"),stderr);
}

if(ttf_file==NULL||facename==NULL){
fprintf(stderr,_("You must specify a TTF file and a face name!\n"));
showhelp();
exit(1);
}

sprintf(slface,"%ssl",facename);

if(fontname[0]!=0)strcpy(fam_name,fontname);

if(access(ttf_file,0)==-1)
fatal(_("Can't open font file %s"),ttf_file);

ttf_basename= trimpath(ttf_file);


/*:18*/
#line 210 "gbkfonts.w"
;
/*5:*/
#line 64 "gbkfonts.w"

if(!Init_Font_Engine(ttf_file))
fatal(_("can't open TrueType engine\n"));

if(fontname[0]==0){
strcpy(fontname,LookUp_Name(6));
if(!bs)fprintf(stderr,_("** Detected font name : %s\n"),fontname);
}

if(fam_name[0]==0){
strcpy(fam_name,LookUp_Name(1));
if(!bs)fprintf(stderr,_("** Detected family name : %s\n"),fam_name);
}

/*:5*/
#line 211 "gbkfonts.w"
;
/*21:*/
#line 322 "gbkfonts.w"

mkdir("fonts",MODE);
mkdir("fonts/afm",MODE);
mkdir("fonts/tfm",MODE);
mkdir("fonts/type1",MODE);
mkdir("fonts/afm/chinese",MODE);
mkdir("fonts/tfm/chinese",MODE);
mkdir("fonts/type1/chinese",MODE);

mkdir("dvips",MODE);
mkdir("dvips/chinese",MODE);

mkdir("pdftex",MODE);
mkdir("pdftex/config",MODE);

mkdir("dvipdfm",MODE);
mkdir("dvipdfm/config",MODE);

mkdir("tex",MODE);
mkdir("tex/latex",MODE);
mkdir("tex/latex/CJK",MODE);
mkdir("tex/latex/CJK/GB",MODE);

sprintf(dvipsdir,"dvips/chinese/%s%s/",prefix,facename);
mkdir(dvipsdir,MODE);

sprintf(afmdir,"fonts/afm/chinese/%s%s/",prefix,facename);
mkdir(afmdir,MODE);

sprintf(tfmdir,"fonts/tfm/chinese/%s%s/",prefix,facename);
mkdir(tfmdir,MODE);

sprintf(type1dir,"fonts/type1/chinese/%s%s/",prefix,facename);
mkdir(type1dir,MODE);

/*:21*/
#line 212 "gbkfonts.w"
;
/*22:*/
#line 357 "gbkfonts.w"

if((pfbmapfile= fopen("cjk.map","a"))==NULL)fatal(_("can't open cjk.map\n"));
sprintf(cmd,"pdftex/config/%s%s.map",prefix,facename);
if((ttfmapfile= fopen(cmd,"w"))==NULL)fatal(_("can't open ttfonts.map\n"));
sprintf(cmd,"dvipdfm/config/%s%s.map",prefix,facename);
if((dvipdfm_mapfile= fopen(cmd,"w"))==NULL)fatal(_("can't open cid-x.map\n"));

/*:22*/
#line 213 "gbkfonts.w"
;

if(!bs)fprintf(stderr,_("** Creating %s%s from %s\n"),prefix,facename,ttf_file);

for(nn= 1;nn<=94;nn++){

if(!bs)fprintf(stderr,"[%d]",nn);
/*9:*/
#line 146 "gbkfonts.w"

sprintf(plane,"%02d",nn);
sprintf(name,"%s%s%s",prefix,facename,plane);
sprintf(slname,"%s%s%s",prefix,slface,plane);

/*:9*/
#line 220 "gbkfonts.w"
;

if(bf)goto skipfontmake;
/*23:*/
#line 364 "gbkfonts.w"

strcpy(cmd,type1dir);
strcat(cmd,name);
strcat(cmd,".ps");
strcpy(cmd1,dvipsdir);
strcat(cmd1,name);
strcat(cmd1,".enc");

ttf2pfb(ttf_file,cmd,cmd1,nn,fontuid);


strcpy(cmd1,type1dir);
strcat(cmd1,name);
strcat(cmd1,".pfb");
t1asm(cmd,cmd1);


unlink(cmd);


#ifdef INSERT
type1afm(cmd1);
#else
strcpy(cmd,"type1afm ");
strcat(cmd,cmd1);
system(cmd);
#endif



strcpy(cmd,type1dir);
strcat(cmd,name);
strcat(cmd,".afm");
sprintf(cmd1,"%s%s.afm",afmdir,name);

#ifndef WIN32
if(link(cmd,cmd1)<0)
if(errno==EEXIST){
unlink(cmd1);
link(cmd,cmd1);
}else{
fprintf(stderr,_("Warning: can't move afm file to destination\n"));
goto dontdelete;
}

unlink(cmd);
dontdelete:
#else
MoveFileEx(cmd,cmd1,MOVEFILE_REPLACE_EXISTING|MOVEFILE_COPY_ALLOWED);
#endif


#ifndef WIN32
sprintf(cmd,"%s%s.afm",afmdir,name);
sprintf(cmd1,"%s%s.tfm",tfmdir,name);
if(fork()==0){
fclose(stdout);
execlp("afm2tfm","afm2tfm",cmd,cmd1,NULL);
}
#else
sprintf(cmd,"afm2tfm %s%s.afm %s%s.tfm",afmdir,name,tfmdir,name);
system(cmd);
#endif



#ifndef WIN32
sprintf(cmd,"%s%s.afm",afmdir,name);
sprintf(cmd1,"%s%s.tfm",tfmdir,slname);
if(fork()==0){
fclose(stdout);
execlp("afm2tfm","afm2tfm",cmd,"-s",".167",cmd1,NULL);
}
#else
sprintf(cmd,"afm2tfm %s%s.afm -s .167 %s%s.tfm",afmdir,name,tfmdir,slname);
system(cmd);
#endif

/*:23*/
#line 223 "gbkfonts.w"
;
skipfontmake:
/*24:*/
#line 442 "gbkfonts.w"


fprintf(ttfmapfile,"%s <%s.enc <%s\n",name,name,ttf_basename);
fprintf(ttfmapfile,"%s <%s.enc <%s\n",slname,name,ttf_basename);
fprintf(dvipdfm_mapfile,"%s none %s\n",name,name);
fprintf(dvipdfm_mapfile,"%s none %s -s 0.167\n",slname,name);


fprintf(pfbmapfile,"%s %s%s <%s.pfb\n",name,fontname,plane,name);

fprintf(pfbmapfile,"%s %s%s \" .167 SlantFont \" < %s.pfb\n",
slname,fontname,plane,name);

/*:24*/
#line 225 "gbkfonts.w"
;
}

fputs("\n",stderr);
/*25:*/
#line 455 "gbkfonts.w"

fclose(ttfmapfile);
fclose(pfbmapfile);
fclose(dvipdfm_mapfile);
/*:25*/
#line 229 "gbkfonts.w"
;
/*10:*/
#line 161 "gbkfonts.w"


fout= fopen("cid-x.map","a");
fprintf(fout,"%s%s@UGBK@\tUniGB-UCS2-H\t:0:%s\n",
prefix,facename,ttf_basename);

fprintf(fout,"%s%ssl@UGBK@\tUniGB-UCS2-H\t:0:%s\n",
prefix,facename,ttf_basename);
fclose(fout);


fout= fopen("pdftex.cfg","a");
fprintf(fout,"map +%s%s.map\n",prefix,facename);
fclose(fout);


fout= fopen("ttfonts.map","a");
fprintf(fout,"%s%s@UGBK@    %s  Pid = 3 Eid = %d\n",prefix,facename,ttf_basename,eid);
fprintf(fout,"%s%s@UGBK@    %s  Slant = 0.167 Pid = 3 Eid = %d\n",
prefix,slface,ttf_basename,eid);
fclose(fout);

/*6:*/
#line 82 "gbkfonts.w"


sprintf(cmd,"tex/latex/CJK/GB/c19%s.fd",facename);
fd_file= fopen(cmd,"w");
fprintf(fd_file,"%% This is the file c19%s.fd of the CJK package\n",facename);
fprintf(fd_file,"%% for using Asian logographs (Chinese/Japanese/Korean) with LaTeX2e\n");
fprintf(fd_file,"%% created by Werner Lemberg <wl@gnu.org>\n");
fprintf(fd_file,"%% Version 4.3.0 (20-Jun-1999)\n\n");
fprintf(fd_file,"\\def\\fileversion{4.3.0}\n");
fprintf(fd_file,"\\def\\filedate{1999/06/20}\n\n");
fprintf(fd_file,"%% \\ProvidesFile{c19%s.fd}[\\filedate\\space\\fileversion]\n",facename);
fprintf(fd_file,"%% Chinese characters (extension of GB 2312)\n");
fprintf(fd_file,"%% character set: GBK\n");
fprintf(fd_file,"%% font encoding: CJK (extended)\n\n");
fprintf(fd_file,"\\DeclareFontFamily{C19}{%s}{}\n",facename);
fprintf(fd_file,"\\DeclareFontShape{C19}{%s}{m}{n}{<-> CJK * %s%s}{}\n",
facename,prefix,facename);
fprintf(fd_file,"\\DeclareFontShape{C19}{%s}{bx}{n}{<-> CJKb * %s%s}{}\n",
facename,prefix,facename);
fprintf(fd_file,
"\\DeclareFontShape{C19}{%s}{m}{it}{<-> CJK * %s%ssl}{}\n",
facename,prefix,facename);
fprintf(fd_file,
"\\DeclareFontShape{C19}{%s}{bx}{it}{<-> CJKb * %s%ssl}{}\n",
facename,prefix,facename);
fprintf(fd_file,
"\\DeclareFontShape{C19}{%s}{m}{sl}{<-> CJK * %s%ssl}{}\n",
facename,prefix,facename);
fprintf(fd_file,
"\\DeclareFontShape{C19}{%s}{bx}{sl}{<-> CJKb * %s%ssl}{}\n",
facename,prefix,facename);
fprintf(fd_file,"\n\\endinput\n");
fclose(fd_file);


/*:6*/
#line 183 "gbkfonts.w"


/*:10*/
#line 230 "gbkfonts.w"
;
return 0;
}

/*:12*/
#line 21 "gbkfonts.w"


/*:1*/
